/*
 * Decompiled with CFR 0.152.
 */
package cml.tools.collections;

import java.util.ArrayList;
import java.util.List;

public class ByteArray {
    private int bufferSize;
    int bufferPosition;
    private List<byte[]> byteLists;

    public ByteArray() {
        this(16384);
    }

    public ByteArray(int n) {
        this.bufferSize = n;
        this.byteLists = new ArrayList<byte[]>();
        this.byteLists.add(new byte[n]);
        this.bufferPosition = 0;
    }

    public void addByte(byte by) {
        this.getCurrentBuffer()[this.bufferPosition++] = by;
        if (this.bufferPosition >= this.bufferSize) {
            this.bufferPosition = 0;
            this.byteLists.add(new byte[this.bufferSize]);
        }
    }

    public void addBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addByte(byArray[i]);
        }
    }

    public int size() {
        return (this.byteLists.size() - 1) * this.bufferSize + this.bufferPosition;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        for (int i = 0; i < this.byteLists.size(); ++i) {
            byte[] byArray2 = this.byteLists.get(i);
            boolean bl = i == this.byteLists.size() - 1;
            int n2 = bl ? this.bufferPosition : byArray2.length;
            for (int j = 0; j < n2; ++j) {
                byArray[n++] = byArray2[j];
            }
        }
        return byArray;
    }

    private byte[] getCurrentBuffer() {
        return this.byteLists.get(this.byteLists.size() - 1);
    }
}

