/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class AsmCommandArgExpr
extends ExprNode {
    private static final AsmCommandArgumentValue noneArgValue = new AsmCommandArgumentValue(0, NumberValue.zero);
    private ExprNode valueExpr;
    private int mode;
    private boolean dereference;

    public AsmCommandArgExpr(int n, ExprNode exprNode) {
        this(n, exprNode, false);
    }

    public AsmCommandArgExpr(int n, ExprNode exprNode, boolean bl) {
        super(exprNode == null ? null : exprNode.getDebugInfo());
        this.valueExpr = exprNode;
        this.mode = n;
        this.dereference = bl;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        if (this.mode == 0) {
            return noneArgValue;
        }
        Value value = this.valueExpr.evaluate(evaluationState);
        if (this.dereference && value.hasRepresentation(Value.RP_ASMARGVALUE)) {
            return value;
        }
        if (!value.isInvalid() && !value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
            throw new AsmError("The value of a Command Argument Value must be an integer. This expression returns a value of type '" + value.getType() + "'", this.debug);
        }
        return new AsmCommandArgumentValue(this.mode, value);
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("AsmArg", this.valueExpr);
        return exprTreeBuilder;
    }
}

