/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.libraries;

import cml.kickass.constant.Constant;
import cml.kickass.function.DoubleFunction;
import cml.kickass.function.DoubleX3Function;
import cml.kickass.function.Function;
import cml.kickass.function.VoidFunction;
import cml.kickass.libraries.Library;
import cml.kickass.values.MatrixValue;
import cml.kickass.values.Value;
import cml.kickass.values.VectorValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VectorLibrary
implements Library {
    public List<Constant> getConstants() {
        return new ArrayList<Constant>();
    }

    @Override
    public Collection<Function> getFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        arrayList.add(new VoidFunction("Vector", (Value)VectorValue.invalid){

            @Override
            protected Value f() {
                return new VectorValue(0.0, 0.0, 0.0);
            }
        });
        arrayList.add(new DoubleX3Function("Vector", (Value)VectorValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                return new VectorValue(d, d2, d3);
            }
        });
        arrayList.add(new VoidFunction("Matrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f() {
                return new MatrixValue(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
            }
        });
        arrayList.add(new DoubleX3Function("RotationMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                double d4 = Math.cos(d);
                double d5 = Math.sin(d);
                double d6 = Math.cos(d2);
                double d7 = Math.sin(d2);
                double d8 = Math.cos(d3);
                double d9 = Math.sin(d3);
                double[][] dArrayArray = new double[][]{{d8 * d6, d8 * d7 * d5 - d9 * d4, d8 * d7 * d4 + d9 * d5, 0.0}, {d9 * d6, d9 * d7 * d5 + d8 * d4, d9 * d7 * d4 - d8 * d5, 0.0}, {-d7, d6 * d5, d6 * d4, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        arrayList.add(new DoubleX3Function("ScaleMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                double[][] dArrayArray = new double[][]{{d, 0.0, 0.0, 0.0}, {0.0, d2, 0.0, 0.0}, {0.0, 0.0, d3, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        arrayList.add(new DoubleX3Function("MoveMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d, double d2, double d3) {
                double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, d}, {0.0, 1.0, 0.0, d2}, {0.0, 0.0, 1.0, d3}, {0.0, 0.0, 0.0, 1.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        arrayList.add(new DoubleFunction("PerspectiveMatrix", (Value)MatrixValue.invalid){

            @Override
            protected Value f(double d) {
                double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0 / d, 0.0}};
                return new MatrixValue(dArrayArray);
            }
        });
        return arrayList;
    }
}

