/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state;

import cml.kickass.lexvalues.DebugInfo;
import java.util.Stack;

public class CallStack {
    private Stack<DebugInfo> stack = new Stack();

    public CallStack() {
        this.stack.ensureCapacity(200);
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public DebugInfo pop() {
        return this.stack.pop();
    }

    public void push(DebugInfo debugInfo) {
        this.stack.push(debugInfo);
    }

    public void popTilDepth(int n) {
        while (this.stack.size() > n) {
            this.stack.pop();
        }
    }

    public String getTrace(DebugInfo debugInfo) {
        int n;
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(debugInfo.getPositionString());
        stringBuffer.append(string);
        for (int i = n = this.stack.size() - 1; i >= 0; --i) {
            stringBuffer.append("called ");
            stringBuffer.append(((DebugInfo)this.stack.get(i)).getPositionString());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

