/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmErrorWithExtraDebug;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LockableValue;
import cml.kickass.values.Value;

public class InvalidUnlockedSideEffectValue
extends LockableValue {
    private DebugInfo setDebug;

    public InvalidUnlockedSideEffectValue(DebugInfo debugInfo) {
        this.setInvalid();
        this.setDebug = debugInfo;
    }

    @Override
    public boolean isInvalid() {
        return true;
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        this.throwException(null);
        return null;
    }

    @Override
    public String getType() {
        this.throwException(null);
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return new InvalidValueFunctionTable();
    }

    @Override
    public void lock(DebugInfo debugInfo) {
    }

    protected void throwException(DebugInfo debugInfo) {
        String string = "You are trying to use an unlocked value accross passes. This is not supported.";
        String string2 = "Try locking the variable with the .define directive or .lock() method before assigning it";
        throw new AsmErrorWithExtraDebug(string, debugInfo, string2, this.setDebug);
    }

    class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        @Override
        public Function get(String string, Value[] valueArray, DebugInfo debugInfo) {
            return new Function(string, null, null, true){

                @Override
                public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                    InvalidUnlockedSideEffectValue.this.throwException(debugInfo);
                    return null;
                }
            };
        }

        @Override
        public boolean exist(String string, Value[] valueArray) {
            throw NotImplementedException.intance;
        }
    }
}

