#version 420

uniform mat4 model_matrix;
uniform mat4 model_view_projection_matrix;


in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec2 out_TexCoord;
out vec3 normal;
out vec4 position;

void main()
{
	mat3 normal_matrix = mat3(model_matrix);
	normal = normalize(normal_matrix * in_Normal);

	position = model_matrix * vec4(in_Vertex, 1.0);

	out_TexCoord = in_TexCoord;
	gl_Position = model_view_projection_matrix * vec4(in_Vertex, 1.0);
}