#version 420

// 1 divided by width and height
uniform vec2 viewport_mul;

// G Buffer
uniform sampler2D normal_buffer;
uniform sampler2D position_buffer;
uniform sampler2D depth_buffer;

// Light uniforms
uniform vec3 light_direction;
uniform vec4 light_color;

uniform vec3 camera_position;

layout(location = 0) out vec4 diffuse;
layout(location = 1) out vec4 specular;

void main()
{
	vec2 tex_coord = gl_FragCoord.xy * viewport_mul;

	vec4 normal_and_specular = texture2D(normal_buffer, tex_coord);

	vec3 normal = normalize(normal_and_specular.rgb);
	vec3 position = texture2D(position_buffer, tex_coord).rgb;

	vec3 viewDir = normalize ( camera_position - position);
	
	vec3 halfDir = normalize ( light_direction + viewDir );
	float lambert = clamp ( dot ( light_direction , normal ) ,0.0 ,1.0);
	float rFactor = clamp ( dot ( halfDir , normal ) ,0.0 ,1.0);
	
	float sFactor = pow ( rFactor , normal_and_specular.a ); // Shininess in worldnormal.a

	diffuse = vec4 ( light_color. xyz * lambert , 1.0);
	specular = vec4 ( light_color. xyz * sFactor *0.33 ,1.0);
}