#version 420

// G Buffer
uniform sampler2D position_buffer;
uniform sampler2D normal_buffer;
uniform sampler2D depth_buffer;
uniform sampler2D ssao_random;

uniform mat4 projection_matrix;
uniform mat4 view_matrix;

uniform float time;

const vec2 screen_size = vec2(1920, 1080);

in vec2 out_TexCoord;

layout(location = 0) out vec4 diffuse;
layout(location = 1) out vec4 spec;
layout(location = 2) out vec4 fragColor;

const int NUM_SAMPLES = 6;
const float radius = 0.2;
const float factor_per_sample = 0.12;

vec3 samples[] = vec3[](
							vec3(  1,  0 ,  0),
							vec3( -1,  0 ,  0),
							vec3(  0,  1 ,  0),
							vec3(  0, -1 ,  0),
							vec3(  0,  0 ,  1),
							vec3(  0,  0 , -1)
					   );

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


void main()
{
	float x = rand(gl_FragCoord.xx * time);
	float y = rand(gl_FragCoord.yy * time);

	vec3 normal_perturb = (texture2D(ssao_random, vec2(x,y)).xyz + 1) / 2;

	const vec2 tex_coord = gl_FragCoord.xy / screen_size;
	vec3 position = texture2D(position_buffer, tex_coord).xyz;
	vec3 normal = texture2D(normal_buffer, tex_coord).xyz;

	float occlusion = 1;
	for (int i = 0; i < NUM_SAMPLES; ++i)
	{
		vec3 sample_position = reflect( (samples[i] * radius) + position, normal_perturb);

		vec4 clip = projection_matrix * view_matrix * vec4(sample_position, 1);
		clip /= clip.w;
		clip.xy = (clip.xy + 1) / 2;

		float depth = (texture2D(depth_buffer, clip.xy).r);
		if (depth > clip.z - 0.01)
		{
			occlusion += factor_per_sample;
		}
		else
		{
			occlusion -= factor_per_sample;
		}
	}
	clamp(occlusion, 0.0, 1.0);
	diffuse = vec4(0);
	spec = vec4(0);
	//fragColor = texture2D(depth_buffer, out_TexCoord);
	fragColor = vec4(occlusion);
	//fragColor = vec4(depth);
	// vec4 pos = projection_matrix * view_matrix * vec4(position, 1);
	// pos /= pos.w ;
	// fragColor = vec4(pos.xy, 0, 0);
}