#version 420

uniform sampler2D scatter;
in vec2 out_TexCoord;
out vec4 fragColor;
const float sampleDist = 1.0;
const float sampleStrength = 2.2; 

uniform float time;
uniform vec2 lightPositionOnScreen1;
uniform vec2 lightPositionOnScreen2;

void main(void)
{
    float samples[10];
    samples[0] = -0.08;
    samples[1] = -0.05;
    samples[2] = -0.03;
    samples[3] = -0.02;
    samples[4] = -0.01;
    samples[5] =  0.01;
    samples[6] =  0.02;
    samples[7] =  0.03;
    samples[8] =  0.05;
    samples[9] =  0.08;

    vec2 dir = 0.5 - out_TexCoord; 
    float dist = sqrt(dir.x*dir.x + dir.y*dir.y); 
    dir = dir/dist; 

    vec4 color = texture2D(scatter,out_TexCoord); 
    vec4 sum = color;

    for (int i = 0; i < 10; i++)
        sum += texture2D( scatter, out_TexCoord + dir * samples[i] * sampleDist );

    sum *= 1.0/11.0;
    float t = dist * sampleStrength;
    t = clamp( t ,0.0,1.0);

    vec4 color1 = mix( color, sum, t );

    const int NUM_SAMPLES = 75 ;
    float exposure = 0.99;
    float decay = 0.7;
    float density = 2.0;
    float weight = 0.3;
    vec2 deltaTextCoord1 = vec2( out_TexCoord.st - lightPositionOnScreen1.xy );
    vec2 deltaTextCoord2 = vec2( out_TexCoord.st - lightPositionOnScreen2.xy );
    vec2 textCoo1 = vec2(out_TexCoord.st);
    vec2 textCoo2 = vec2(out_TexCoord.st);

    deltaTextCoord1 *= 1.0 /  NUM_SAMPLES * density;
    deltaTextCoord2 *= 1.0 /  NUM_SAMPLES * density;
    float illuminationDecay1 = 0.5;
    float illuminationDecay2 = 0.5;
    for(int i=0; i < NUM_SAMPLES ; i++)
    {
        textCoo1 -= deltaTextCoord1;
        vec4 texel1 = texture2D(scatter, textCoo1 );
        texel1 *= illuminationDecay1 * weight;
        fragColor += texel1;
        illuminationDecay1 *= decay;

        textCoo2 -= deltaTextCoord2;
        vec4 texel2 = texture2D(scatter, textCoo2 );
        texel2 *= illuminationDecay2 * weight;
        fragColor += texel2;
        illuminationDecay2 *= decay;
    }
    fragColor *= exposure;
    fragColor += color1;
    fragColor /= 2;

}