#version 420
#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D tex;

uniform float distort;
uniform int direction;
in vec2 out_TexCoord;

out vec4 fragColor;

void main()
{
	vec2 texcoord = out_TexCoord;
	float distort2 = distort;

    ivec2 size = textureSize2D(tex,0);
    float total = floor((texcoord.x)*1920.0); +
                  floor((texcoord.y)*1080.0);
    bool isEven = mod(total,2.0)==0.0;
    if (isEven)
    {
        if (direction % 2 == 0)
    	   texcoord.y += cos(texcoord.x + distort2) * distort2;
        else
           texcoord.x += cos(texcoord.y + distort2) * distort2;
    }
    else
    {
        if (direction % 2 == 0)
           texcoord.y -= cos(texcoord.x + distort2) * distort2;
        else
           texcoord.x -= cos(texcoord.y + distort2) * distort2;
    }
    vec4 finalColor = texture2D(tex, texcoord);
    fragColor = finalColor;
}
