#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform float time;
in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec2 out_TexCoord;

void main()
{
	out_TexCoord = in_TexCoord;
	vec4 v = vec4(in_Vertex, 1.0);
	v.x += sin(time + v.y * v.x);
	v.y += sin(sin(time/2) + v.x);
	v.z += cos(sin(time/3) + v.x);

	gl_Position = projectionMatrix * modelViewMatrix * v;
}