#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D cloudTex : register(t0);
Texture2D rayTex : register(t1);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(2.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
FLAT_DS_TO_GS

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
[maxvertexcount(6)]
void GS(triangle VFPosTexCoord input[3], inout TriangleStream<PixelInput> OutputStream)
{
	float3 normal = normalize(cross(input[1].pos - input[0].pos, input[2].pos - input[0].pos));

	if (dot(normal, float3(0.0f, 0.0f, 1.0f)) < 0.95f)
		return;

	PixelInput output = (PixelInput)0;
	output.pos.xyz = (input[0].pos + input[1].pos + input[2].pos) / 3.0f;
	output.pos.w = 1.0f;

	float mask = 1.0f - cloudTex.SampleLevel(clampSampler, input[0].texcoord, 0.0f);

	if (mask < 0.5f)
		return;

	if (distance(output.pos.xyz, cameraPos.xyz) > 5000.0f)
		return;

	float uniqueness = abs(sin(output.pos.x) + cos(output.pos.y) + sin(output.pos.z));

	output.color = GetDefaultLighting(normal);//1.0f - uniqueness * 0.2f;
	output.texcoord = input[0].texcoord;
	//output.pos = mul(output.pos, viewProj);
	//output.pos = mul(output.pos, projection);
	output.color = mask;
	float2 Sprite[4] = {
		float2(0, 0), 
		float2(1, 0), 
		float2(0, -1), 
		float2(1, -1)
	};
	
	for (int i = 0; i < 4; i++)
	{
		PixelInput v1 = output;
		float2 offset = Sprite[i] * float2(10.0f, 50.0f);
		
		//offset.x += (Sprite[i].y) * sin(uniqueness + time * sin(uniqueness)) * 1.0f;
		//offset.y += (Sprite[i].y) * cos(uniqueness + time) * 1.0f;
		offset.x += (Sprite[i].y) * sin(output.pos.x * 0.02f + time * 0.1f) * 40.0f;
		offset.y += (Sprite[i].y) * cos(output.pos.y * 0.02f + time * 0.1f) * 20.0f;

		v1.pos.xz += offset * particle /* uniqueness*/;
		
		v1.pos += Sprite[i].y * light0Dir * 500.0f;

		/*light0Dir*/
		v1.texcoord.x = Sprite[i].x;
		v1.texcoord.y = 1.0f - Sprite[i].y;
		v1.color *= 1.0f - Sprite[i].y;
		v1.worldPos = v1.pos;
		v1.pos = mul(v1.pos, viewProj);
		OutputStream.Append(v1);
	}

	OutputStream.RestartStrip();
}

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float4 color = rayTex.Sample(wrapSampler, input.texcoord * float2(1.0f, 1.0f)) * input.color * 0.05f;
	
	return color;
}
