
cbuffer MeshBuffer : register(b1)
{
	matrix transform;
	float2 particle;
	float lod;
	float texScale;
	float4 fogColor;
	float gamma;
	float brightness;
	float saturation;
	float jitter;
	float blurFade;
	float flashFade;
	float fogDist;
}

cbuffer ConstantBuffer : register(b0)
{
	matrix viewProj;
	float4 cameraPos;
	//
	float time;
	float sceneTime;
	float sceneLength;
	float segmentTime;
	//
	float segmentLength;
	float segmentPos;
	float segmentFadeIn;
	float segmentFadeOut;
	//
	float4 light0Dir;
	float4 light0Color;
	float4 light1Dir;
	float4 light1Color;
	float4 ambientColor;
}

SamplerState clampSampler : register(s0);
SamplerState wrapSampler : register(s1);


struct VFPos
{
	float3 pos : POSITION;
};

struct VFPosColor
{
	float3 pos : POSITION;
	float4 color : COLOR;
};

struct VFPosTexCoord
{
	float3 pos : POSITION;
	float2 texcoord : TEXCOORD;
};

struct VFPosNormal
{
	float3 pos : POSITION;
	float3 normal : NORMAL;
};


struct PixelInput
{
    float4 pos : SV_POSITION;
    float4 color : COLOR0;
	float2 texcoord : TEXCOORD0;
	float3 worldPos : TEXCOORD1;
};

struct HS_ConstantOutput_Quad
{
    float fTessFactor[4]       : SV_TessFactor;
    float fInsideTessFactor[2] : SV_InsideTessFactor;
};

float4 bilerpUV(float4 v[4], float2 uv)
{
    // bilerp the texture coordinates    
    float4 bottom = lerp( v[0], v[1], uv.x );
    float4 top = lerp( v[3], v[2], uv.x );
    float4 result = lerp( bottom, top, uv.y );
	
    return result;    
}

float2 bilerpUV2(float2 v[4], float2 uv)
{
    // bilerp the texture coordinates    
    float2 bottom = lerp( v[0], v[1], uv.x );
    float2 top = lerp( v[3], v[2], uv.x );
    float2 result = lerp( bottom, top, uv.y );
	
    return result;    
}

float3 GetGimPos(Texture2D gim, float2 uv)
{
	return mul(gim.SampleLevel(clampSampler, uv, 0.0f), transform);
}

float3 GetBlendedGimPos(Texture2D srcGim, Texture2D dstGim, float2 srcUV, float2 dstUV, float blend)
{
	float4 src = srcGim.SampleLevel(clampSampler, srcUV, 0.0f);
	float4 dst = dstGim.SampleLevel(clampSampler, dstUV, 0.0f);
	
	float4 pos = lerp(src, dst, blend);

	return mul(pos, transform);
}
/*

VFPosNormal GetGimPosNormal(Texture2D gim, float2 uv)
{
	float3 p1 = GetGimPos(gim, uv);
	float3 p2 = GetGimPos(gim, uv + float2(0.0f, 0.01f));
	float3 p3 = GetGimPos(gim, uv + float2(0.01f, 0.0f));
	
	VFPosNormal v;
	v.pos = p1;
	v.normal = normalize(cross(p2 - p1, p3 - p1));

	return v;
}
*/

/*
VFPosNormal GetBlendedGimPosNormal(Texture2D srcGim, Texture2D dstGim, float2 srcUV, float2 dstUV, float blend)
{
	VFPosNormal src = GetGimPosNormal(srcGim, srcUV);
	VFPosNormal dst = GetGimPosNormal(dstGim, dstUV);

	VFPosNormal r;
	r.pos = lerp(src.pos, dst.pos, blend);
	r.normal = lerp(src.normal, dst.normal, blend);
	
	return r;
}
*/

float3 GetHeightMapPos(Texture2D heighmap, float2 uv)
{
	//return mul(float4(uv.x, uv.y, 0.0f, 1.0f), transform);
	return mul(float4(uv.x, 1.0f - uv.y, heighmap.SampleLevel(clampSampler, float2(uv.x, uv.y), 0.0f).x, 1.0f), transform);
}

/*
VFPosNormal GetHeightMapPosNormal(Texture2D heighmap, float2 uv)
{
	float3 p1 = GetHeightMapPos(heighmap, uv);
	float3 p2 = GetHeightMapPos(heighmap, uv + float2(0.0f, 0.01f));
	float3 p3 = GetHeightMapPos(heighmap, uv + float2(0.01f, 0.0f));
	
	VFPosNormal v;
	v.pos = p1;
	v.normal = normalize(cross(p2 - p1, p3 - p1));

	return v;
}*/

float4 GetDefaultLighting(float3 normal)
{
	float4 color = 1;

	//color.xyz = normal;//normalize(normal) * 0.5f + 0.5f;
	
	color = saturate(dot(normal, normalize(light0Dir.xyz))) * light0Color;
	color += saturate(dot(normal, normalize(light1Dir.xyz))) * light1Color;
	color += ambientColor * 2.0f;

	return pow(color, 1.0f);
}

float4 GetSpecularLighting(float3 worldPos, float3 normal, float exponent)
{
	float3 L = normalize(light0Dir.xyz);   
	float3 E = normalize(cameraPos.xyz - worldPos);
	float3 R = normalize(-reflect(L, normal));  

	float specular = pow(max(dot(R,E),0.0f), exponent);
	specular = clamp(specular, 0.0, 1.0); 

	return specular * light0Color;
}

float GetFade()
{
	float fIn = segmentFadeIn > 0.0f ? saturate((segmentTime / segmentFadeIn)) : 1.0f;
	float fOut = segmentFadeOut > 0.0f ? saturate(((segmentLength - segmentTime) / segmentFadeOut)) : 1.0f;
	
	return fIn * fOut;
}

//Generic functions
float4 ApplyFadeInOut(float4 input)
{
	
	//return lerp(flashFade, input, fIn * fOut);//input + (1.0f - saturate(fIn * fOut)) * ;
	return (flashFade < 0.5f) ? input * GetFade() : input + (1.0f - GetFade());
}


float4 ApplyGamma(float4 input)
{
	return pow(input * brightness, gamma);
}

float2 ApplyJitter(float2 input)
{
	float2 r = input;
	r.x += sin(time * 0.35f) * cos(time * 0.17f) * jitter * 0.01f; 
	r.y += cos(time * 0.3f) * sin(time * 0.25f) * jitter * 0.01f; 
	return r;
}

float4 ApplyFog(float4 color, float depth)
{
	if (depth >= 10000.0f)
		return color;

	float fog = saturate(depth / fogDist);

	return lerp(color, fogColor, fog);
}
/*
VFPosTexCoord staticGimDSFunc(const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation, Texture2D gim)
{
	VFPosTexCoord output = (VFPosTexCoord)0;

	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);
	output.pos = GetGimPos(gim, output.texcoord);
	return output;
}
*/

float getLinearDepth(float depth)
{
	float zNear = 0.1f;
	float zFar = 10000.0f;

	float z_b = depth;
    float z_n = 2.0 * z_b - 1.0;
    float z_e = 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));

	return z_e;
}


#define CONSTANT_QUAD_TESS(n)\
HS_ConstantOutput_Quad TessFunc(InputPatch<VFPos, 4> input)\
{\
	HS_ConstantOutput_Quad output;\
    output.fTessFactor[0] = n;\
	output.fTessFactor[1] = n;\
	output.fTessFactor[2] = n;\
	output.fTessFactor[3] = n;\
    output.fInsideTessFactor[0] = n;\
	output.fInsideTessFactor[1] = n;\
    return output;\
}

////////////////////////////////////////////
//Vertex shader templates
////////////////////////////////////////////
#define GENERIC_VS\
VFPos VS( VFPos input )\
{\
	VFPos output = (VFPos)0;\
	output.pos = input.pos;\
	return output;\
}

////////////////////////////////////////////
//Hull shader templates
////////////////////////////////////////////
#define GENERIC_HS\
[domain("quad")]\
[partitioning("pow2")]\
[outputtopology("triangle_ccw")]\
[patchconstantfunc("TessFunc")]\
[outputcontrolpoints(4)]\
VFPos HS( InputPatch<VFPos, 4> input, uint uCPID : SV_OutputControlPointID )\
{\
    VFPos output = (VFPos)0;\
    output.pos = input[uCPID].pos;\
    return output;\
}

////////////////////////////////////////////
//Domain shader templates
////////////////////////////////////////////
#define GIM_DS(g)\
[domain("quad")]\
PixelInput DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	PixelInput output = (PixelInput)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos.xyz = GetGimPos(g, output.texcoord);\
	output.pos.w = 1.0f;\
	output.pos = mul(output.pos, viewProj);\
	output.color = 1.0f;\
	return output;\
}

#define GIM_DS_TO_GS(g)\
[domain("quad")]\
VFPosTexCoord DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	VFPosTexCoord output = (VFPosTexCoord)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos = GetGimPos(g, output.texcoord);\
	return output;\
}

#define GIM_BLENDED_DS(g_src, g_dst, t)\
[domain("quad")]\
PixelInput DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	PixelInput output = (PixelInput)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos.xyz = GetBlendedGimPos(g_src, g_dst, output.texcoord, output.texcoord, t);\
	output.pos.w = 1.0f;\
	output.pos = mul(output.pos, viewProj);\
	output.color = 1.0f;\
	return output;\
}

#define GIM_BLENDED_DS_TO_GS(g_src, g_dst, t)\
[domain("quad")]\
VFPosTexCoord DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	VFPosTexCoord output = (VFPosTexCoord)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos = GetBlendedGimPos(g_src, g_dst, output.texcoord, output.texcoord, t);\
	return output;\
}

#define HEIGHTMAP_DS(hmap)\
[domain("quad")]\
PixelInput DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	PixelInput output = (PixelInput)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos.xyz = GetHeightMapPos(hmap, output.texcoord);\
	output.pos.w = 1.0f;\
	output.worldPos = output.pos.xyz;\
	output.pos = mul(output.pos, viewProj);\
	output.color = 1.0f;\
	return output;\
}

#define HEIGHTMAP_DS_TO_GS(hmap)\
[domain("quad")]\
VFPosTexCoord DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	VFPosTexCoord output = (VFPosTexCoord)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos = GetHeightMapPos(hmap, output.texcoord);\
	return output;\
}

#define FLAT_DS_TO_GS\
[domain("quad")]\
VFPosTexCoord DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	VFPosTexCoord output = (VFPosTexCoord)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos = mul(float4(output.texcoord.x, 1.0f - output.texcoord.y, 0.0f, 1.0f), transform);\
	return output;\
}

#define FLAT_DS\
[domain("quad")]\
PixelInput DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	PixelInput output = (PixelInput)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos.xyz = mul(float4(output.texcoord.x, 1.0f - output.texcoord.y, 0.0f, 1.0f), transform);\
	output.pos.w = 1.0f;\
	output.pos = mul(output.pos, viewProj);\
	return output;\
}

#define FULLSCREEN_DS\
[domain("quad")]\
PixelInput DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )\
{\
	PixelInput output = (PixelInput)0;\
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);\
	output.pos.x = output.texcoord.x * 2.0f - 1.0f;\
	output.pos.y = 1.0f - output.texcoord.y * 2.0f;\
	output.pos.z = 1.0f;\
	output.pos.w = 1.0f;\
	output.color = 1.0f;\
	return output;\
}
////////////////////////////////////////////
//Geometry shader templates
////////////////////////////////////////////
#define GENERIC_GS_LIT\
[maxvertexcount(3)]\
void GS(triangle VFPosTexCoord input[3], inout TriangleStream<PixelInput> OutputStream)\
{\
	float4 lighting = GetDefaultLighting(normalize(cross(input[1].pos - input[0].pos, input[2].pos - input[0].pos)));\
	for (int i = 0; i < 3; i++)\
	{\
		PixelInput output = (PixelInput)0;\
		output.pos.xyz = input[i].pos;\
		output.pos.w = 1.0f;\
		output.color = lighting;\
		output.texcoord = input[i].texcoord;\
		output.pos = mul(output.pos, viewProj);\
		OutputStream.Append(output);\
	}\
}

////////////////////////////////////////////
//Pixel shader templates
////////////////////////////////////////////
#define GENERIC_PS\
float4 PS( PixelInput input ) : SV_Target\
{\
	return input.color;\
}

#define SOLIDCOLOR_PS(r,g,b,a)\
float4 PS( PixelInput input ) : SV_Target\
{\
	return float4(r,g,b,a);\
}
