#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D gim_src : register(t0);
Texture2D nmap_src : register(t1);
Texture2D diffuseTex : register(t2);
Texture2D gim_dst : register(t3);
Texture2D nmap_dst : register(t4);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(8.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
GIM_BLENDED_DS(gim_src, gim_dst, segmentPos)

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
GENERIC_GS_LIT

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float3 n_src = nmap_src.Sample(clampSampler, input.texcoord).xyz;
	float3 n_dst = nmap_dst.Sample(clampSampler, input.texcoord).xyz;
	float3 n = mul(lerp(n_src, n_dst, segmentPos) * 2.0f - 1.0f, transform);
	float4 diffuse = diffuseTex.Sample(wrapSampler, input.texcoord);
	return GetDefaultLighting(normalize(n)) * diffuse;
}
