
Texture2D gim_src : register(t0);
Texture2D gim_dst : register(t1);

SamplerState mipSampler : register(s0);

cbuffer MeshConst : register(b1)
{
	matrix transform;
	//float2 heightScale;
	//float2 patchScale;
	//float2 texcoordScale;
	float2 lodDist;
}

cbuffer ConstantBuffer : register(b0)
{
	float3 camPos;
	//matrix world;
	matrix view;
	matrix projection;
	float time;
}

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
	float4 pos : POSITION;
	float4 color : COLOR;
};

struct VS_OUTPUT
{
    float4 pos : SV_POSITION;
    float4 color : COLOR0;
	float2 texcoord : TEXCOORD0;
};

struct HS_ConstantOutput_Quad
{
    float fTessFactor[4]       : SV_TessFactor;
    float fInsideTessFactor[2] : SV_InsideTessFactor;
};

//sample from gim
float3 getGimPos(float2 p)
{
	float4 gim_src1_pos = gim_src.SampleLevel(mipSampler, p, 0.0f);
	float4 gim_dst_pos = gim_dst.SampleLevel(mipSampler, p, 0.0f);
	
	float f = abs(sin(time * 0.1f));

	float4 pos = lerp(gim_src1_pos, gim_dst_pos, f);

	return mul(pos, transform);
}
//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
VS_OUTPUT VS( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT)0;

	//patch transformation
	//output.pos = mul( input.pos, world );
	output.pos = input.pos;
	output.texcoord = input.pos.xy;
	//blend vertex for smooth patch lod transition
	float d = 0.0f;//saturate(((distance(camPos, output.pos) - 40.0f) / lodDist) - input.color.z * 255.0f);

	output.pos.x += d * input.color.x * output.pos.y;
	output.pos.y += d * input.color.y * output.pos.y;
	
	float3 appPos = output.pos;
	appPos = getGimPos(input.pos.xy);

	output.color.z = pow(1.0f - saturate((distance(camPos, appPos)) / 400.0f), 10.f);

	output.color.xy = input.pos.xy;

	return output;
}

//--------------------------------------------------------------------------------------
//Hull Shader
//--------------------------------------------------------------------------------------
HS_ConstantOutput_Quad HS_QuadsConstant( InputPatch<VS_OUTPUT, 4> I )
{
	HS_ConstantOutput_Quad O = (HS_ConstantOutput_Quad)0;
    
    float2 ritf,itf; float4 rtf;

	//Calculate tesselation factor for each patch (quad) according to color.z

	Process2DQuadTessFactorsAvg(/*pow(I[0].color.z, 1.0f) */8.0f, 1.0f, rtf, ritf, itf);

    O.fTessFactor[0] = rtf.x;
	O.fTessFactor[1] = rtf.y;
	O.fTessFactor[2] = rtf.z;
	O.fTessFactor[3] = rtf.w;
    O.fInsideTessFactor[0] = ritf.x;
	O.fInsideTessFactor[1] = ritf.y;

    return O;
}

[domain("quad")]
[partitioning("pow2")]
[outputtopology("triangle_ccw")]
[patchconstantfunc("HS_QuadsConstant")]
[outputcontrolpoints(4)]
VS_OUTPUT HS( InputPatch<VS_OUTPUT, 4> I, uint uCPID : SV_OutputControlPointID )
{
    VS_OUTPUT O = (VS_OUTPUT)0;

    O.pos = I[uCPID].pos;
    O.color = I[uCPID].color;
    O.texcoord = I[uCPID].texcoord;

    return O;
}

//--------------------------------------------------------------------------------------
// Domain Shader
//--------------------------------------------------------------------------------------
float4 bilerpUV(float4 v[4], float2 uv)
{
    // bilerp the texture coordinates    
    float4 bottom = lerp( v[0], v[1], uv.x );
    float4 top = lerp( v[3], v[2], uv.x );
    float4 result = lerp( bottom, top, uv.y );
	
    return result;    
}

float2 bilerpUV2(float2 v[4], float2 uv)
{
    // bilerp the texture coordinates    
    float2 bottom = lerp( v[0], v[1], uv.x );
    float2 top = lerp( v[3], v[2], uv.x );
    float2 result = lerp( bottom, top, uv.y );
	
    return result;    
}

[domain("quad")]
VS_OUTPUT DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VS_OUTPUT, 4> I, float2 coords : SV_DomainLocation )
{
    VS_OUTPUT output = (VS_OUTPUT)0;

	//quad
	float4 p[4]; 
	float4 c[4]; 
	float2 t[4]; 
	
	[unroll]
	for (uint i=0; i<4; i++)
	{
	    p[i]=I[i].pos;
	    c[i]=I[i].color;
	    t[i]=I[i].texcoord;
	}

	//interpolate position + color according to tesselation position (coords)
	output.pos = bilerpUV(p, coords);
	output.color = bilerpUV(c, coords);
	output.texcoord = bilerpUV2(t, coords);

	float3 p1 = getGimPos(output.pos.xy);
	float3 p2 = getGimPos(output.pos.xy + float2(0.01f, 0.0f));
	float3 p3 = getGimPos(output.pos.xy + float2(0.0, 0.01f));

	float3 normal = normalize(cross(p2 - p1, p3 - p1));

	output.color.xyz = gim_src.SampleLevel(mipSampler, output.pos.xy, 0.0f);

	output.pos.xyz = p1;
/*	
	output.color.xyz = 0.5f + 0.5f * normal;//output.pos.xyz / 512.0f;

	output.color *= dot(normal, normalize(float3(1.0f, 0.0f, 1.0f)));
	*/
	output.pos = mul( output.pos, view );
    output.pos = mul( output.pos, projection );

	return output;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( VS_OUTPUT input ) : SV_Target
{
	return input.color;
	//return float4(input.texcoord.x, input.texcoord.y, 0.0f, 1.0f);
	//return lightmap.Sample(mipSampler, input.texcoord);
}
