#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D gim : register(t0);
Texture2D nmap : register(t1);
Texture2D diffuseTex : register(t2);


////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(8.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
GIM_DS(gim)

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
GENERIC_GS_LIT

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float4 diffuse = diffuseTex.Sample(wrapSampler, input.texcoord * texScale);

	return diffuse;
}
