#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D gim : register(t0);
Texture2D diffuse : register(t2);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(1.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
GIM_DS_TO_GS(gim)

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
[maxvertexcount(6)]
void GS(triangle VFPosTexCoord input[3], inout TriangleStream<PixelInput> OutputStream)
{
	float4 lighting = GetDefaultLighting(normalize(cross(input[1].pos - input[0].pos, input[2].pos - input[0].pos)));

	PixelInput output = (PixelInput)0;
	output.pos.xyz = (input[0].pos + input[1].pos + input[2].pos) / 3.0f;
	output.pos.w = 1.0f;
	output.color = lighting;
	output.texcoord = input[0].texcoord;
	output.pos = mul(output.pos, viewProj);
	//output.pos = mul(output.pos, projection);

	float2 Sprite[4] = {
		float2(-1, -1), 
		float2(1, -1), 
		float2(-1, 1), 
		float2(1, 1)
	};
	
	for (int i = 0; i < 4; i++)
	{
		PixelInput v1 = output;
		v1.pos.xy += Sprite[i] * particle;
		v1.texcoord = Sprite[i] * 0.5f + 0.5f;
		OutputStream.Append(v1);
	}

	OutputStream.RestartStrip();
}

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	return diffuse.Sample(clampSampler, input.texcoord);
}
