#include "common.hlsl"


////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
PixelInput VS( VFPos input )
{
	PixelInput output = (PixelInput) 0;
	
	output.pos.xyz = input.pos.xyz;
	output.pos.w = 1.0f;
	output.pos = mul(output.pos, transform);

	output.pos = mul(output.pos, viewProj);
	output.color = input.pos.x == 0.5f ? float4(1.0f, 0.0f, 0.0f, 1.0f) : float4(1.0f, 1.0f, 0.0f, 1.0f);
	return output;
}

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS(PixelInput input) : SV_Target
{
	return input.color;
}
