#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D colorBuf : register(t0);
Texture2D depthBuf : register(t1);

////////////////////////////////////////////
// Vertex Shader

////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(1.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
FULLSCREEN_DS

float4 PS( PixelInput input ) : SV_Target
{
	input.texcoord = ApplyJitter(input.texcoord);

	float4 color = colorBuf.Sample(clampSampler, input.texcoord);
	float depth = getLinearDepth(depthBuf.Sample(clampSampler, input.texcoord).x);
	
	color = ApplyFog(color, depth);
	color = ApplyFadeInOut(color);
	color = ApplyGamma(color);
	color.w = 1.0f;

	return color;

/*	float pdepth = getLinearDepth(depthBuf.Sample(clampSampler, input.texcoord).x) / 1000.0f;

	int taps = 0;

	float4 accum = colorBuf.Sample(clampSampler, input.texcoord);
	float accumTaps = 1.0f;

	for (int i = 0; i < 10; i++)
	{
		input.texcoord.x += i * 0.001f * pdepth;
		input.texcoord.y += i * 0.001f * pdepth;
		
		float depth = getLinearDepth(depthBuf.Sample(clampSampler, input.texcoord).x) / 1000.0f;

		if (depth * 1.1f > pdepth)
		{
			accum += colorBuf.Sample(clampSampler, input.texcoord);
			accumTaps += 1.0f;
		}
	}

	float4 sunspot;
	sunspot.xyz = light0Dir.xyz * 1000.0f;
	sunspot.w = 1.0f;

	sunspot = mul(sunspot, viewProj);

	float sun = 1.0f - saturate(distance(sunspot.xy, input.texcoord * 2.0f - 1.0f));

	return (accum / accumTaps) * GetFadeInOut();*/
}

