#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D colorBuf : register(t0);
Texture2D depthBuf : register(t1);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(1.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
FULLSCREEN_DS

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////

float4 PS( PixelInput input ) : SV_Target
{
	float pdepth = getLinearDepth(depthBuf.Sample(clampSampler, input.texcoord).x);

	float4 color = colorBuf.Sample(clampSampler, input.texcoord);

	color = ApplyFog(color, pdepth, 0.0f, 5000.0f, float4(0.3f, 0.5f, 0.7f, 1.0f));

	color = saturate(pow(color * 1.8f, 1.5f)) * GetFadeInOut();

	return color;
}

