#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D gim : register(t0);
Texture2D diffuseTex : register(t1);
Texture2D maskTex : register(t2);
Texture2D lightmapTex : register(t3);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(4.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
HEIGHTMAP_DS_TO_GS(gim)

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
[maxvertexcount(6)]
void GS(triangle VFPosTexCoord input[3], inout TriangleStream<PixelInput> OutputStream)
{
	float3 normal = normalize(cross(input[1].pos - input[0].pos, input[2].pos - input[0].pos));

	if (dot(normal, float3(0.0f, 0.0f, 1.0f)) < 0.95f)
		return;

	PixelInput output = (PixelInput)0;
	output.pos.xyz = (input[0].pos + input[1].pos + input[2].pos) / 3.0f;
	output.pos.w = 1.0f;

	float mask = maskTex.SampleLevel(clampSampler, input[0].texcoord, 0.0f);

	if (mask < 0.5f)
		return;

	if (distance(output.pos.xyz, cameraPos.xyz) > 1500.0f)
		return;

	float light = lightmapTex.SampleLevel(clampSampler, input[0].texcoord, 0.0f);

	float uniqueness = abs(sin(output.pos.x) + cos(output.pos.y) + sin(output.pos.z));

	output.color = GetDefaultLighting(normal);//1.0f - uniqueness * 0.2f;
	output.texcoord = input[0].texcoord;
	output.pos = mul(output.pos, viewProj);
	//output.pos = mul(output.pos, projection);
	output.color = mask * light;
	float2 Sprite[4] = {
		float2(-1, -1), 
		float2(1, -1), 
		float2(-1, 1), 
		float2(1, 1)
	};
	
	for (int i = 0; i < 4; i++)
	{
		PixelInput v1 = output;
		float2 offset = Sprite[i] + float2(0.0f, 1.0f);
		
		offset.x += (Sprite[i].y + 1.0f) * sin(uniqueness + time * 0.5f * sin(uniqueness)) * 0.1f;
		//offset.y += (Sprite[i].y + 1.0f) * cos(uniqueness + time) * 0.1f;

		v1.pos.xy += offset * particle * uniqueness;
		v1.texcoord = 1.0f - (Sprite[i] * 0.5f + 0.5f);
		OutputStream.Append(v1);
	}

	OutputStream.RestartStrip();
}

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float4 color = diffuseTex.Sample(clampSampler, input.texcoord * float2(1.0f, 1.0f));
	
	if (color.w < 0.5f)
		discard;
	
	return color * input.color;
}
