#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D heightmap : register(t0);
Texture2D layer0Tex : register(t1);
Texture2D layer1Tex : register(t2);
Texture2D lightmapTex : register(t3);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(8.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
HEIGHTMAP_DS(heightmap)

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float2 uv = input.texcoord - 0.002f;
	float3 p1 = GetHeightMapPos(heightmap, uv);
	float3 p2 = GetHeightMapPos(heightmap, uv + float2(0.0f, 0.002f));
	float3 p3 = GetHeightMapPos(heightmap, uv + float2(0.002f, 0.0f));
	
	float3 normal = normalize(cross(p2 - p1, p3 - p1));
	float4 layer0 = layer0Tex.Sample(wrapSampler, input.texcoord * texScale);
	float4 layer1 = layer1Tex.Sample(wrapSampler, input.texcoord * texScale);
	float mix = pow(dot(normal, float3(0.0f, 0.0f, 1.0f)), 3.0f);
	float4 diffuse = lerp(layer1, layer0, mix);

	float lightmap = saturate(lightmapTex.Sample(clampSampler, input.texcoord).x * 2.0f);

	float specular = GetSpecularLighting(input.worldPos, normal, 8.0f) * 0.5f;

	return diffuse * (GetDefaultLighting(normal) + specular) * lightmap;
}
