#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D heightmap : register(t0);
Texture2D layer0Tex : register(t1);
Texture2D layer1Tex : register(t2);
Texture2D lightmapTex : register(t3);
Texture2D maskTex : register(t4);
Texture2D layer2Tex : register(t5);
Texture2D waterflowTex : register(t6);
Texture2D grassgrowTex : register(t7);
Texture2D grassTex : register(t8);




////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(8.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
HEIGHTMAP_DS(heightmap)

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float2 uv = input.texcoord - 0.002f;
	float3 p1 = GetHeightMapPos(heightmap, uv);
	float3 p2 = GetHeightMapPos(heightmap, uv + float2(0.0f, 0.002f));
	float3 p3 = GetHeightMapPos(heightmap, uv + float2(0.002f, 0.0f));
	
	float3 normal = normalize(cross(p2 - p1, p3 - p1));
	float4 layer0 = layer0Tex.Sample(wrapSampler, input.texcoord * texScale);
	float4 layer1 = layer1Tex.Sample(wrapSampler, input.texcoord * texScale);
	float mix = pow(dot(normal, float3(0.0f, 0.0f, 1.0f)), 3.0f);
	float4 diffuse = lerp(layer1, layer0, mix);

	float lightmap = saturate(lightmapTex.Sample(clampSampler, input.texcoord).x * 2.0f);

	float mask = maskTex.Sample(clampSampler, input.texcoord).x;
	float4 layer2 = layer2Tex.Sample(wrapSampler, input.texcoord * texScale);
	diffuse = lerp(layer2, diffuse, mask);

	float waterflow = waterflowTex.Sample(clampSampler, input.texcoord).x;
	float grassflow = grassgrowTex.Sample(clampSampler, input.texcoord).x;

	float4 water = float4(0.0f, 0.0f, 1.0f, 1.0f);
	float4 grass = grassTex.Sample(clampSampler, input.texcoord);

	float waterAlpha = saturate((waterflow - saturate(1.0f - segmentPos - 0.2f)) / 0.1f );
	float grassAlpha = saturate((grassflow - (1.0f - segmentPos)) / 0.2f );

	diffuse = lerp(diffuse, diffuse * 0.5f, waterAlpha);
	diffuse = lerp(diffuse, grass, grassAlpha);
	
	float3 bumpfuzz = float3(sin(time + input.worldPos.x * 10.0f) * -0.1, cos(time + input.worldPos.x * 5.0f) * -0.1, 0.0f);

	float4 specular = GetSpecularLighting(input.worldPos, normal + bumpfuzz, 50.0f) * saturate(waterAlpha - grassAlpha);

	return diffuse * GetDefaultLighting(normal) * lightmap + specular;
}
