#include "common.hlsl"


////////////////////////////////////////////
//Input textures
////////////////////////////////////////////
Texture2D gim : register(t0);
Texture2D diffuse : register(t2);

////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////
GENERIC_VS

////////////////////////////////////////////
// Hull Shader
////////////////////////////////////////////
CONSTANT_QUAD_TESS(1.0f)
GENERIC_HS

////////////////////////////////////////////
// Domain Shader
////////////////////////////////////////////
[domain("quad")]
VFPosTexCoord DS( HS_ConstantOutput_Quad HSConstantData, const OutputPatch<VFPos, 4> input, float2 coords : SV_DomainLocation )
{
	VFPosTexCoord output = (VFPosTexCoord)0;
	output.texcoord = lerp(lerp(input[0].pos, input[1].pos, coords.x ), lerp(input[3].pos, input[2].pos, coords.x ), coords.y);
	return output;
}

////////////////////////////////////////////
// Geometry Shader
////////////////////////////////////////////
[maxvertexcount(6)]
void GS(triangle VFPosTexCoord input[3], inout TriangleStream<PixelInput> OutputStream)
{
	float2 midCoord = (input[0].texcoord + input[1].texcoord + input[1].texcoord) / 3.0f; 

	float lifetime = frac(time * 0.005f + midCoord.y);
	float2 coord = float2(midCoord.x, 1.0f - lifetime);

	PixelInput output = (PixelInput)0;
	output.pos.xyz = GetGimPos(gim, coord);
	output.pos.w = 1.0f;
	output.color.xy = midCoord.xy;
	output.color.z = lifetime;
	output.texcoord = 0;


	//output.pos = mul(output.pos, viewProj);

	float2 Sprite[4] = {
		float2(-1, -1), 
		float2(1, -1), 
		float2(-1, 1), 
		float2(1, 1)
	};

	float uniqueness = abs(sin(input[0].texcoord.x * 10.0f) + cos(input[0].texcoord.y * 10.f));

	output.texcoord.y += time;

	float2 particleSize = particle.x - 5.0f * sin(time * 0.5f + uniqueness * 10);
		
	particleSize += 10.0f *(1.0f - 2.0f * abs(input[0].texcoord.y - 0.5f));
	
	float angle =  5.0f * sin(time * 0.02f + uniqueness * 5.0f);

	output.color.x = 1.0f;// - pow(lifetime, 8.0f);

	for (int i = 0; i < 4; i++)
	{
		PixelInput v1 = output;
		float2 p = Sprite[i];
		float2 pr;
		pr.x = p.x * cos(angle) - p.y * sin(angle);
		pr.y = p.y * cos(angle) + p.x * sin(angle);
		v1.pos.xy += pr * particleSize;
		v1.texcoord = Sprite[i] * 0.5f + 0.5f;
		v1.pos = mul(v1.pos, viewProj);
		OutputStream.Append(v1);
	}

	OutputStream.RestartStrip();
}

////////////////////////////////////////////
// Pixel Shader
////////////////////////////////////////////
float4 PS( PixelInput input ) : SV_Target
{
	float4 c = diffuse.Sample(clampSampler, input.texcoord) * input.color.x * 0.2f; 
	return c;
}
