#version 430 core


layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

out vec3 light_dir;

#define EMIT(VTX) \
	light_dir = dir; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	vec3 dir = normalize(gl_in[0].gl_Position.xyz);

	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));

	EndPrimitive();
}
