#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
uniform float terrainTexCoordScale;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 3) in vec4 TANGENT;
layout (location = 4) in vec2 TEXCOORD;

out vec3 normal;
out vec4 tangent;
out vec2 uv;
out vec3 world_uvw;

void main()
{
	uv = TEXCOORD;
	world_uvw = vec3(WorldMatrix * vec4(POSITION,1.0)) * terrainTexCoordScale;
	normal = NormalMatrix * normalize(NORMAL);
	tangent.xyz = NormalMatrix * normalize(TANGENT.xyz);
	tangent.w = TANGENT.w;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
