#version 430 core

in vec3 gs_light_pos[1];
in vec3 gs_light_dir[1];
in vec3 gs_light_color[1];

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

out vec3 light_pos;
out vec3 light_dir;
out vec3 light_color;

#define EMIT(VTX) \
	light_pos = light_pos; \
	light_dir = gs_light_dir[0]; \
	light_color = gs_light_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	EndPrimitive();
}

