#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D dof_buffer;
uniform sampler2D depth_buffer;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <post/blit_include.frag>

#include <post/dof_include.frag>

vec4 dofBlur(in sampler2D tex, in vec2 uv, in float coc)
{
#if 0
	vec4 final;
	final  = texture(tex, uv - 3.0*TexelSize)*0.06;
	final += texture(tex, uv - 2.0*TexelSize)*0.125;
	final += texture(tex, uv - 1.0*TexelSize)*0.1875;
	final += texture(tex, uv                )*0.25;
	final += texture(tex, uv + 1.0*TexelSize)*0.1875;
	final += texture(tex, uv + 2.0*TexelSize)*0.125;
	final += texture(tex, uv + 3.0*TexelSize)*0.06;
	return final;
#else
	return textureLod(tex, uv, 0.0);
#endif
}

void main()
{
	vec2 uv2 = distort_uv(uv);

	vec4 c0 = textureLod(color_buffer, uv2, 0.0);
	//vec4 c1 = textureLod(dof_buffer, uv2, 0.0);
	float z = texture(depth_buffer, uv2).x;

	float coc = circleOfConfusion(z);
	vec4 c1 = dofBlur(dof_buffer, uv2, coc);

	vec4 c = c0*(1.0 - coc) + c1*coc;
	c.a = c0.a;

	frag_color = color_lookup(c, uv);
}
