uniform vec4      CameraRange; // near, far, (far - near), (-near*far)
uniform vec4      DOFParams;   // aperture, FocalLength, PlaneInFocus, PlaneInFocus - FocalLength
uniform float     projCoeffs[5];

float circleOfConfusion(in float d)
{
#if 0
	//vec4 wpos;
	//wpos.x = (uv_pos.x - 0.5)*2.0*projCoeffs[0];
	//wpos.y = (uv_pos.y - 0.5)*2.0*projCoeffs[1];
	float z = projCoeffs[2];
	float w = (d - 0.5)*2.0*projCoeffs[3] + projCoeffs[4];
	float objDist = z / w;

	//objectdistance = -zfar * znear / (z * (zfar - znear) - zfar)
	//CoC = abs(aperture * (focallength * (objectdistance - planeinfocus)) / (objectdistance * (planeinfocus - focallength)))

	// float objDist = CameraRange.w / ((z - 0.5)*2.0 * CameraRange.z - CameraRange.y);
	float coc = abs(DOFParams.x * (DOFParams.y * (objDist - DOFParams.z)) / (objDist * DOFParams.w));
	return clamp(coc, 0.0, 1.0);
#else
	float zz = (d - 0.5)*2.0;
	float obj_dist = CameraRange.w / (zz*CameraRange.z - CameraRange.y);
	float coc = abs( DOFParams.x * (DOFParams.y * (obj_dist - DOFParams.z)) / (obj_dist * DOFParams.w) );
	return clamp(coc, 0.0, 1.0);
#endif
}
