#version 330 core

uniform sampler2D tex;

uniform vec2 Direction[2];
uniform vec2 TexelSize;
uniform vec4 Weights[2];
uniform float B;
uniform vec4 color;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#define LOD_LEVEL 0.0

vec4 sampleStreak(in vec4 weights, in vec2 sc)
{
	vec4 final = textureLod(tex, uv, LOD_LEVEL)*weights.x;

	final += textureLod(tex, uv + sc, LOD_LEVEL)*weights.y;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*weights.y;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*weights.z;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*weights.z;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*weights.w;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*weights.w;
	final *= 1.0 / 6.0;

	return final;
}


void main()
{
#if 0
	vec2 sc = Direction*TexelSize*B;

	vec4 final = textureLod(tex, uv, LOD_LEVEL)*Weights.x;

	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.y;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.y;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.z;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.z;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.w;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.w;
	final *= 1.0 / 6.0;
#else
	vec4 final = sampleStreak(Weights[0], Direction[0]*TexelSize*B);
	final += sampleStreak(Weights[1], Direction[1]*TexelSize*B);
	final /= 2.0;
#endif
	//frag_color = (final - color)*color.a*final.a;
	frag_color = final*color.a*final.a;
	frag_color.a = 1.0;
}
