#version 330 core

uniform sampler2D tex;
uniform vec2 TexelSize;
uniform vec2 Origin;
uniform vec2 RadialBlurParams;
uniform vec4 color;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	const int numSamples = 32;

	vec4 final = vec4(0.0);
	for (int i=0; i < numSamples; i++)
	{
		float k = RadialBlurParams.x + RadialBlurParams.y*(float(i)/float(numSamples-1));
		final += texture(tex, uv*k + Origin);
	}

	final *= 1.0 / float(numSamples);
	//frag_color = (final - color)*color.a;
	frag_color = final*color.a*final.a;
	frag_color.a = 1.0;
}
