#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL; // velocity
layout (location = 2) in vec3 COLOR; // force
layout (location = 3) in vec3 TANGENT; // <radius,energy,1/mass>

out vec3 ec_pos;
out vec2 uv_offset;
out vec4 extinction;
out vec3 inscatter;
out float fade;

#include <shading_model/atmosphere_include.frag>

void main()
{
	vec3 n = vec3(0.0, 1.0, 0.0);
	//calculateCloudAtmosphere(POSITION, n, extinction, inscatter);
	calculateGroundAtmosphereDualSided(POSITION, n, extinction, inscatter);

	fade = max(dot(n, SunDirection), 0.0);

	uv_offset = TANGENT.yz;

	vec3 wPos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	ec_pos = wPos;

	float ratio = min(length(ec_pos) / 256.0, 1.0);
	gl_PointSize = 128.0*TANGENT.x * (1.0 - ratio);

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
