#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform vec2 CloudsOffset;
uniform float CloudHeightScale;

in vec3 POSITION;

out vec2 uv;
out vec2 uv_noise;
out vec4 normal;
out vec4 extinction;
out vec3 inscatter;
out vec3 ec_pos;

#include <shading_model/atmosphere_include.frag>

void main()
{
	vec3 n = normalize(-POSITION);
	calculateCloudAtmosphere(POSITION*CloudHeightScale, n, extinction, inscatter);

	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	//
	//normal = NormalMatrix * n;
	normal.xyz = n;
	normal.w = smoothstep(0.0, 1.0, POSITION.y*0.01);
	uv = (POSITION.xz / 250.0) + CloudsOffset;
	uv_noise = sin(CloudsOffset.yx) + (uv.yx + CloudsOffset.yx)*0.5;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
