#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

in vec2 g_uv[3];
in vec3 g_normal[3];

out vec2 uv;
out vec3 wpos;
out float fade;

const int SHELL_COUNT = 6;

layout(triangles) in;
layout(triangle_strip, max_vertices = 18) out;


void main()
{
	for(int j=0; j <= SHELL_COUNT; j++)
	{
		float k = float(j) / float(SHELL_COUNT);
		for(int i=0; i < 3; i++)
		{
			vec4 pos = gl_in[i].gl_Position;
			vec3 dir = normalize(g_normal[i].xyz) * 50.0;
			pos.xyz += dir*k;

			fade = pow(1.0 - k, 2.0);
			uv = g_uv[i];
			wpos = vec3(ModelViewMatrix * pos);
			gl_Position = ModelViewProjectionMatrix * pos;
			EmitVertex();
		}
		EndPrimitive();
	}
}
