#version 430 core

uniform sampler2D diffusemap;  // diffuse rgb, specular
uniform sampler2D normalmap; // specular rgb, smoothness
uniform sampler2D emissivemap;
uniform float smoothness;

in vec3 normal;
in vec4 tangent;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

void main()
{
	vec3 t = normalize(tangent.xyz);
	vec3 n = normalize(normal);
	vec3 b = normalize( cross(n, t) * tangent.w );
	
	vec3 bn = texture(normalmap, uv).xyz*2.0 - vec3(1.0);
	mat3 mr = mat3(t, b, n);
	n = normalize(mr*bn);

	vec4 diff = texture(diffusemap, uv);
	float emis = texture(emissivemap, uv).x;

	gb_diffuse.rgb = diff.rgb;  // diffuse.rgb
	gb_diffuse.a = 0.0;

	gb_specular.rgb = diff.rgb*diff.a; // specular rgb, smoothness
	gb_specular.a = smoothness;//spec.a;

	gb_normal.xyz = n;   // normal xyz, ?
	gb_normal.w = 0.0;

	gb_light.rgb = vec3(0.6, 0.8, 1.0)*diff.rgb*emis;
	gb_light.a = emis; //step(0.1, emis);
}
