#version 430 core

uniform sampler2D gb_depth;
uniform sampler2D starmap;
uniform vec2 viewport;

in vec2 uv;
in vec3 ec_pos;
in vec4 diffuse;
in float fade;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(gb_depth, uv_pos).x;
	if ( d < 1.0 ) discard;
	frag_color = diffuse + texture(starmap, uv*2.0)*fade*0.125;
	frag_color.a = 1.0;
}
