#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform float CloudHeightScale;
uniform float time;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec2 uv;
out vec3 ec_pos;
out vec4 diffuse;
out float fade;

#include <shading_model/atmosphere_include.frag>

void main()
{
	uv = TEXCOORD;
	fade = sin((uv.x + uv.y)*4.0 + time*5.0)*0.25 + 1.0;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	calculateSkydomeAtmosphere(POSITION*CloudHeightScale*2.0, diffuse);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
