#version 430 core

uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;

in vec3 params[1]; // radius, energy, 1/mass

out vec2 uv;
out vec3 wpos;
out float fade;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	fade = energy; \
	wpos = (VTX).xyz; \
	gl_Position = ProjectionMatrix * vec4(VTX, 1.0); \
	EmitVertex()

void main()
{
	float radius = params[0].x;
	float energy = params[0].y;
	if ( radius <= 0.0 || energy <= 0.0 ) return;

	vec4 pos = ModelViewMatrix * gl_in[0].gl_Position;

	vec3 a = pos.xyz + vec3( 1.0,  1.0, 0.0)*radius;
	vec3 b = pos.xyz + vec3(-1.0,  1.0, 0.0)*radius;
	vec3 c = pos.xyz + vec3(-1.0, -1.0, 0.0)*radius;
	vec3 d = pos.xyz + vec3( 1.0, -1.0, 0.0)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));
	EndPrimitive();
}
