#version 430 core

uniform sampler2D diffusemap;
uniform sampler2D specularmap;
uniform sampler2D normalmap;
uniform float smoothness;

in vec3 normal;
in vec4 tangent;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

#if 0
#include <deferred/tangentspace_include.frag>
#endif

void main()
{
	vec3 t = normalize(tangent.xyz);
	vec3 n = normalize(normal);
	//vec3 b = normalize(cross(n, t)*tangent.w);
	vec3 b = normalize(cross(n, t));

	vec3 bn = texture(normalmap, uv).xyz*2.0 - vec3(1.0);
	mat3 mr = mat3(t, b, n);
	n = normalize(mr*bn);

	vec4 diff = texture(diffusemap, uv);

	gb_diffuse.rgb = diff.rgb;  // diffuse.rgb
	gb_diffuse.a = 0.0;

	gb_specular.rgb = diff.rgb * diff.a; // specular rgb, smoothness
	gb_specular.a = smoothness;

	gb_normal.xyz = n;   // normal xyz, ?
	gb_normal.w = 0.0;

	gb_light = vec4(0.0);
}
