
float schlickFresnel(in float ior, in float NdotE)
{
	float kr = (ior - 1.0) / (ior + 1.0);
	kr *= kr;
	return kr + (1.0 - kr)*pow(1.0 - NdotE, 5.0);
}


vec3 calculate_material_model(in vec3 n, in vec3 l, in vec3 e, in float shininess)
{
	vec3 hv = normalize(l + e);
	float NdotL = dot(n, l);
	float NdotE = dot(n, e);
	float NdotHV = dot(n, hv);

	float diffTerm = max(NdotL, 0.0);
	float specTerm = exp( -pow(acos(NdotHV) / shininess, 2.0) ) * step(0.0, NdotL);
	float fresTerm = schlickFresnel(1.5, NdotE)*0.25;

	return vec3(diffTerm, specTerm, fresTerm);
}
