#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 CameraMatrix[6];

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

void main()
{
	vec4 pos[3];
	for (int i=0; i < 3; i++)
	{
		pos[i] = ModelViewMatrix * gl_in[i].gl_Position;
	}

	for (int l=0; l < 6; l++)
	{
		for (int i=0; i < 3; i++)
		{
			gl_Layer = l;
			gl_Position = ProjectionMatrix * (CameraMatrix[l] * pos[i]);
			EmitVertex();
		}
		EndPrimitive();
	}
}
