// gauss filter with variable radius

uniform sampler2D texture;
uniform sampler2D displace;
uniform vec2 texelOffset;
uniform vec4 displaceOffset;
uniform vec4 sourceRect;
uniform float fade;

//varying vec2 uv;
varying vec4 pos;

void main()
{
   vec2 uv;
   uv.x= (pos.x / pos.w) - sourceRect.x;
   uv.y= (pos.y / pos.w) - sourceRect.y;

   uv.x *= sourceRect.z;
   uv.y *= sourceRect.w;

   // sample displacement map
   float dx1= texture2D(displace, uv*0.60 + texelOffset*displaceOffset.xy).r - 0.5;
   float dy1= texture2D(displace, uv*0.50 + texelOffset*displaceOffset.yz).r - 0.5;
   float dx2= texture2D(displace, uv*0.55 - texelOffset*displaceOffset.zw).r - 0.5;
   float dy2= texture2D(displace, uv*0.45 - texelOffset*displaceOffset.wx).r - 0.5;

   dx1*=0.03;
   dy1*=0.03;
   dx2*=0.03;
   dy2*=0.03;

   // center element
   vec4 c1= texture2D(texture, uv+vec2(dx1,dy1));
   vec4 c2= texture2D(texture, uv+vec2(dx2,dy2));

   vec4 c3= texture2D(texture, uv);
   vec4 result= (c1+c2) * 0.5 * fade;
   gl_FragColor= result;
}
