alias demo_glenz {

        drawrect -nrf @dm.glenz.1 $rgb(255,0,255) 0 0 0 320 180
        draw_cube $calc(%dm.c / 1000) $calc(%dm.c / 2000) $calc(%dm.c / 3000    ) -1 @dm.glenz.1
        drawrect -nrf @dm.glenz.2 $rgb(255,0,255) 0 0 0 320 180
        draw_cube $calc(%dm.c / 1000) $calc(%dm.c / 2000) $calc(%dm.c / 3000) 1 @dm.glenz.2

        drawpic -nc @demo 0 0 $qt($scriptdirimg\sky.png)

        drawcopy -nt @dm.glenz.1 $rgb(255,0,255) 0 0 320 180 @demo 0 0
        ;draw shifted -> blending omgz!!!
        drawcopy -nt @dm.glenz.2 $rgb(255,0,255) 1 0 320 180 @demo 0 0

        drawtext -nr @demo $rgb(255, 255, 255) Impact 48 %dm.glenz.scroll.x 110 %dm.glenz.scroll.text

        ddec dm.glenz.scroll.x .18

        if (%dm.c > 27500) {

                .signal -n dmSelectPart crash
                halt
        }

        dmDrawFrame demo_glenz
}

;;draws a cube. $1 = x angle, $2 = y angle, $3 = z angle, $4 = 1 or -1 depending on whether we want front or back faces, $5 = where to draw to

alias draw_cube {
        rotate_xyz $1 $2 $3 -1 -1 -1 vert_a_x vert_a_y
        rotate_xyz $1 $2 $3  1 -1 -1 vert_b_x vert_b_y
        rotate_xyz $1 $2 $3 -1  1 -1 vert_c_x vert_c_y
        rotate_xyz $1 $2 $3  1  1 -1 vert_d_x vert_d_y
        rotate_xyz $1 $2 $3 -1 -1  1 vert_e_x vert_e_y
        rotate_xyz $1 $2 $3  1 -1  1 vert_f_x vert_f_y
        rotate_xyz $1 $2 $3 -1  1  1 vert_g_x vert_g_y
        rotate_xyz $1 $2 $3  1  1  1 vert_h_x vert_h_y

        draw_quad 1 4210880 %vert_a_x %vert_a_y %vert_c_x %vert_c_y %vert_d_x %vert_d_y %vert_b_x %vert_b_y $qt($scriptdirimg\red.png) $4 $5
        draw_quad 1 4210880 %vert_b_x %vert_b_y %vert_d_x %vert_d_y %vert_h_x %vert_h_y %vert_f_x %vert_f_y $qt($scriptdirimg\blue.png) $4 $5
        draw_quad 1 4210880 %vert_c_x %vert_c_y %vert_g_x %vert_g_y %vert_h_x %vert_h_y %vert_d_x %vert_d_y $qt($scriptdirimg\teal.png) $4 $5
        draw_quad 1 4210880 %vert_g_x %vert_g_y %vert_c_x %vert_c_y %vert_a_x %vert_a_y %vert_e_x %vert_e_y $qt($scriptdirimg\purple.png) $4 $5
        draw_quad 1 4210880 %vert_g_x %vert_g_y %vert_e_x %vert_e_y %vert_f_x %vert_f_y %vert_h_x %vert_h_y $qt($scriptdirimg\pink.png) $4 $5
        draw_quad 1 4210880 %vert_a_x %vert_a_y %vert_b_x %vert_b_y %vert_f_x %vert_f_y %vert_e_x %vert_e_y $qt($scriptdirimg\apricot.png) $4 $5
}

;;draw a quad. $1 = border, $2 = fill, $3,$4 = x1,y1, $5,$6 = x2,y2 etc.
;;$11 = pattern, $12 = 1 or -1 depending on whether we want front or back faces
;;$13 = where to draw to

alias draw_quad {
        set %rx1 $calc($5 - $3)
        set %ry1 $calc($6 - $4)
        set %rx2 $calc($7 - $5)
        set %ry2 $calc($8 - $6)
        set %dot $calc((%rx1 * %ry2 - %rx2 * %ry1) * $12)

        if (%dot < 0) {

                drawline -nr $13 $1 2 $3 $4 $5 $6 $7 $8 $9 $10 $3 $4

                set %midx $calc(($3 + $5 + $7 + $9)  / 4)
                set %midy $calc(($4 + $6 + $8 + $10) / 4)

                ;TODO: check whether the polygon is too narrow?

                drawfill -nr $13 $2 $1 %midx %midy $11
                ;drawfill -nr $13 $2 $1 %midx %midy
        }
}

;;$1 = angle (radians), $2,$3,$4 = x,y,z, $5,$6,$7 = out vars
alias rotate_x {

        var %s $sin($1)
        var %c $cos($1)

        set $+(%,$5) $2
        set $+(%,$6) $calc(%c * $3 + %s * $4)
        set $+(%,$7) $calc(-1 * %s * $3 + %c * $4)
}

alias rotate_y {

        var %s $sin($1)
        var %c $cos($1)

        set $+(%,$5) $calc(%c * $2 - %s * $4)
        set $+(%,$6) $3
        set $+(%,$7) $calc(%s * $2 + %c * $4)
}

alias rotate_z {

        var %s $sin($1)
        var %c $cos($1)

        set $+(%,$5) $calc(%c * $2 + %s * $3)
        set $+(%,$6) $calc(-1 * %s * $2 + %c * $3)
        set $+(%,$7) $4
}

;;rotates point around $1,$2,$3, translates, projects and returns in $7,$8
alias rotate_xyz {

        rotate_x $1 $4       $5       $6       temp_x  temp_y  temp_z
        rotate_y $2 %temp_x  %temp_y  %temp_z  temp_x2 temp_y2 temp_z2
        rotate_z $3 %temp_x2 %temp_y2 %temp_z2 temp_x3 temp_y3 temp_z3

        set %zofs 3
        set $+(%,$7) $calc((($sin($calc(%dm.c / 7)).deg * 64) + 160) + (($sin($calc(%dm.c / 8)).deg * 16) + 64) * (%temp_x3 / (%temp_z3 + %zofs)))
        set $+(%,$8) $calc( 65                                       + (($sin($calc(%dm.c / 8)).deg * 16) + 64) * (%temp_y3 / (%temp_z3 + %zofs)))
        ;set $+(%,$7) $calc(160 + 100 * (%temp_x3 / (%temp_z3 + %zofs)))
        ;set $+(%,$8) $calc( 90 + 100 * (%temp_y3 / (%temp_z3 + %zofs)))
}
