#! /bin/sh

# 45/10 Mbit total. 5 of those are utterly reserved to streaming.
# The remaining 40 are split between organizer and public networks,
# with each having prioritized 10 Mbit/sec and then sharing the rest.
#
#                   root
#                 /      \
#  [1:1] stream(5)        [1:2] others(40) 
#                        /                \
#           [1:3] orgas(10+borrow)   [1:4] public(10+borrow)

TOTAL_RATE=10000
ORGA_PRIO_RATE=1000
PUBLIC_PRIO_RATE=1000
STREAM_RESERVED_RATE=5000
DO_NAT=1

# Note that if ORGA_PRIO_RATE + PUBLIC_PRIO_RATE > NON_STREAM_RATE,
# NON_STREAM_RATE will be effectively ignored!
NON_STREAM_RATE=$(( TOTAL_RATE - STREAM_RESERVED_RATE ))

ORGANIZER_MARK=2
STREAM_MARK=3

IFACE=solskogen

ethtool -K eth0 tso off
ethtool -K eth0 gso off

# simple marking rules (note, traffic _to_ stream segment is unmarked!)
iptables -t mangle -F INPUT
iptables -t mangle -A INPUT -s 10.0.1.0/24 -j MARK --set-mark $ORGANIZER_MARK
iptables -t mangle -A INPUT -d 193.35.53.10/24 -j MARK --set-mark $ORGANIZER_MARK
iptables -t mangle -A INPUT -s 10.0.2.0/24 -j MARK --set-mark $STREAM_MARK

iptables -t mangle -F OUTPUT

iptables -t mangle -F FORWARD
iptables -t mangle -A FORWARD -s 193.35.53.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu  # ick
iptables -t mangle -A FORWARD -s 10.0.1.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu  # ick
iptables -t mangle -A FORWARD -s 10.0.2.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu  # ick
iptables -t mangle -A FORWARD -s 10.0.1.0/24 -j MARK --set-mark $ORGANIZER_MARK
iptables -t mangle -A FORWARD -d 193.35.53.10/24 -j MARK --set-mark $ORGANIZER_MARK
iptables -t mangle -A FORWARD -s 10.0.2.0/24 -j MARK --set-mark $STREAM_MARK

# some NAT (ick!)
if [ "$DO_NAT" = "1" ]; then
	iptables -t nat -F POSTROUTING
	iptables -t nat -A POSTROUTING -s 10.0.1.0/24 -j SNAT --to-source 193.35.53.10
	iptables -t nat -A POSTROUTING -s 10.0.2.0/24 -j SNAT --to-source 193.35.53.11
fi

# same for ipv6
ip6tables -t mangle -F INPUT
ip6tables -t mangle -A INPUT -s 2001:67c:29f4:2001::/64 -j MARK --set-mark $ORGANIZER_MARK
ip6tables -t mangle -A INPUT -d 2001:67c:29f4:2001::/64 -j MARK --set-mark $ORGANIZER_MARK
ip6tables -t mangle -A INPUT -s 2001:67c:29f4:2002::/64 -j MARK --set-mark $STREAM_MARK

ip6tables -t mangle -F FORWARD
ip6tables -t mangle -A FORWARD -s 2001:67c:29f4:2001::/64 -j MARK --set-mark $ORGANIZER_MARK
ip6tables -t mangle -A FORWARD -d 2001:67c:29f4:2001::/64 -j MARK --set-mark $ORGANIZER_MARK
ip6tables -t mangle -A FORWARD -s 2001:67c:29f4:2002::/64 -j MARK --set-mark $STREAM_MARK

ip6tables -t mangle -F OUTPUT

# reset tc
tc qdisc del dev $IFACE root

# root qdisc should be htb, default class is 1:4 (public)
tc qdisc add dev $IFACE root handle 1: htb r2q 1 default 4

if [ "$STREAM_RESERVED_RATE" -gt 0 ]; then
  # streaming traffic is a simple codel queue
  tc class add dev $IFACE parent 1: classid 1:1 htb rate ${STREAM_RESERVED_RATE}kbit
  tc filter add dev $IFACE parent 1: handle ${STREAM_MARK} fw classid 1:1
  tc qdisc add dev $IFACE parent 1:1 codel ecn
fi

# public+organizer network is a simple inner class
# (no traffic goes directly into it, since that it disallowed in htb)
tc class add dev $IFACE parent 1: classid 1:2 htb rate ${NON_STREAM_RATE}kbit
tc qdisc add dev $IFACE parent 1:2 fq_codel ecn flows 65536

# orga network: guaranteed a certain rate, the rest is for borrowing
tc class add dev $IFACE parent 1:2 classid 1:3 htb rate ${ORGA_PRIO_RATE}kbit ceil ${NON_STREAM_RATE}kbit
tc filter add dev $IFACE parent 1: handle ${ORGANIZER_MARK} fw classid 1:3
tc qdisc add dev $IFACE parent 1:3 fq_codel ecn flows 65536

# public (same as orga)
tc class add dev $IFACE parent 1:2 classid 1:4 htb rate ${PUBLIC_PRIO_RATE}kbit ceil ${NON_STREAM_RATE}kbit
tc qdisc add dev $IFACE parent 1:4 fq_codel ecn flows 65536
