﻿//Going forward scene


var Forward = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Forward.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Forward.prototype.initScene = function(){
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  
  this.cameraGroup = new THREE.Object3D();
  this.scene.add(this.cameraGroup);
  
  this.camera = new THREE.PerspectiveCamera();
  this.cameraGroup.add(this.camera);
  
  this.createSurroundings();
  
  THREE.ImageUtils.crossOrigin = true;
  var texture = THREE.ImageUtils.loadTexture("bin/sprite-v2.png");
  var spriteMaterial = new THREE.SpriteMaterial({map : texture});
  this.character = new THREE.Sprite(spriteMaterial);
  this.character.position.z = -10;
  this.character.position.y = -3;
  this.character.position.normalize();
  
  this.character.scale = new THREE.Vector3(0.5,0.5,0.5);
  
  this.cameraGroup.add(this.character);
  
  this.cameraGroup.position.z = 400;
  this.cameraGroup.position.y = 20;
  this.cameraGroup.rotation.x = Math.PI/100;
  
  this.createRain();
  this.createPeople();
  this.createClouds();
  
  //FADING IN AND OUT
  
  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  this.rtt = new THREE.WebGLRenderTarget(1024, 1024);
  
  this.createPreScene();
  this.createPostScene();
  
  //Ajoitukset
  //ensimmäinen kontrollipiste
  this.point1 = {s : -200, z : this.cameraGroup.position.z, t : 44, started : false};
  this.point2 = {s : Math.PI/3, r : this.camera.rotation.x, t : 48, start : this.point1.t, started : false};
  
  this.swipeSpeed = 0.01;
  
  //feidaukset
  this.blinks = {
    fadeIn : {t : this.startTime+1.0, done : false},
    
    close1 : {t : this.point2.t+4, done : false},
    open2 : {t : this.point2.t+6, done : false},
    
    fadeOut : {t : this.endTime-1, done : false}
  }
}

//rendering function
Forward.prototype.render = function(elapsedTime){
  if(!this.blinks.fadeIn.done){
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.preScene, this.preCamera);
  }
  else{
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.postScene, this.postCamera);
  }
}

Forward.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;

  this.uniformsSwipe =  {
    angle : {type : "f", value: -2.0},
    scene1 : {type : "t", value: rtt},
    scene2 : {type : "t", value: this.rtt},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
  };

  this.swipeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsSwipe,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'swipe').textContent,
  });
  
  this.prePlane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.swipeMaterial);
  this.preScene.add(this.prePlane);
  
}

Forward.prototype.finish = function(elapsedTime, rtt){
  TDEMO.renderer.render(this.scene, this.camera, this.rtt);
  TDEMO.renderer.render(this.postScene, this.postCamera, rtt);
}

Forward.prototype.animate = function(elapsedTime){
  
  //alun sisäänfeidaus
  if(!this.blinks.fadeIn.done && elapsedTime >= this.blinks.fadeIn.t){    
    this.uniformsSwipe.angle.value += this.swipeSpeed;
    if(this.uniformsSwipe.angle.value >= 0.5){
      this.blinks.fadeIn.done = true;
    }
  }
 
  //kävely
  if(elapsedTime <= this.point1.t){
    if(!this.point1.started){
      var t1 = this.point1.t - elapsedTime;
      this.point1.v = this.point1.s / t1;
      this.point1.started = true;
    }
    
    var s1 = this.point1.v * (elapsedTime - this.startTime);
    this.cameraGroup.position.z = this.point1.z + s1;    
  }
  else if(elapsedTime <= this.point2.t){//kameran kääntyminen
    if(!this.point2.started){
      var t2 = this.point2.t - elapsedTime;
      this.point2.v = this.point2.s / t2;
      this.point2.started = true;
    }
    
    var s2 = this.point2.v * (elapsedTime - this.point2.start);
    this.camera.rotation.x = this.point2.r + s2;
  }
  else{//Lopun silmien räpyttelyt
    if(!this.blinks.close1.done && elapsedTime >= this.blinks.close1.t){
      this.uniformsBlink.phase.value -= 0.1;
      
      if(this.uniformsBlink.phase.value <= -2){
        this.uniformsBlink.phase.value = -2.0;
        this.blinks.close1.done = true;
      }
    }
    else if(!this.blinks.open2.done && elapsedTime >= this.blinks.open2.t){
      this.uniformsBlink.phase.value += 0.05;
      
      if(this.uniformsBlink.phase.value >= 2){
        this.uniformsBlink.phase.value = 2.0;
        this.blinks.open2.done = true;
      }
    }
    else if(!this.blinks.fadeOut.done && elapsedTime >= this.blinks.fadeOut.t){
      this.uniformsBlink.phase.value -= 0.1;
      
      if(this.uniformsBlink.phase.value <= -2){
        this.uniformsBlink.phase.value = -2.0;
        this.blinks.fadeOut.done = true;
      }
    }
  }
  
  this.rain.rotation.x += 0.001; 
  this.cloudUniforms.time.value = (elapsedTime/3);
}

Forward.prototype.createSurroundings = function(){
  var ambient = new THREE.AmbientLight(0xFFFFAA);
  this.scene.add(ambient);
  this.scene.fog = new THREE.Fog(0xC0D9D9, 15.0, 620 );

  var skyMaterial = new THREE.MeshBasicMaterial({
    color : 0x7171C6,
    side: THREE.BackSide
  });
  this.skyBox = new THREE.Mesh(new THREE.SphereGeometry(500, 16, 16), skyMaterial);
  this.scene.add(this.skyBox);
  
  var groundMaterial = new THREE.MeshBasicMaterial({
    color: 0x3A3A38
  });
  this.ground = new THREE.Mesh(new THREE.PlaneGeometry(1600, 1600), groundMaterial);
  this.ground.rotation.x = -Math.PI/2;
  this.scene.add(this.ground);
}

Forward.prototype.createRain = function(){
  //PARTIKKELEITA
  THREE.ImageUtils.crossOrigin = true;
  var texture = THREE.ImageUtils.loadTexture("bin/pisara.png");
  var particleCount = 9000;
  var particles = new THREE.Geometry();
  var colors = [];

  for (var i = 0; i < particleCount; i++) {

    var particle = new THREE.Vector3();
    particle.x = Math.random() * 300 - 150;
    particle.y = Math.random() * 500;
    particle.z = Math.random() * 500 - 250;

    particles.vertices.push(particle);
  }
  
  var particleMaterial = new THREE.ParticleSystemMaterial( { size: 2, map : texture, transparent: true } );
  
  this.rain = new THREE.ParticleSystem( particles, particleMaterial );
  this.rain.sortParticles = true;

  this.scene.add(this.rain );
}

Forward.prototype.createPeople = function(){
  //PARTIKKELEITA
  THREE.ImageUtils.crossOrigin = true;
  var texture = THREE.ImageUtils.loadTexture("bin/kiiltokuva-square.png");
  var particleCount = 3;
  var particles = new THREE.Geometry();
  var x = -100;
  var delta = 100;

  for (var i = 0; i < particleCount; i++) {
    var particle = new THREE.Vector3();
    particle.x = x;
    particle.z = -200;
    
    x +=delta;
    
    particles.vertices.push(particle);
    
  }
  
  var particleMaterial = new THREE.ParticleSystemMaterial( { size: 100, map : texture, transparent: true } );
  this.people = new THREE.ParticleSystem( particles, particleMaterial );
  this.people.position.y = 20;
  
  this.scene.add(this.people );
}

Forward.prototype.createClouds = function() {
  this.cloudUniforms = { 
    time    : { type : "f", value:  0.0 },
    opacity : { type : "f", value:  0.9 },
    c0      : { type : "f", value:  5.0 },
    c1      : { type : "f", value:  3.0 },
    c2      : { type : "f", value:  11.0 },
    c3      : { type : "f", value:  7.0 },
    c4      : { type : "f", value:  9.0 },
    c5      : { type : "f", value:  3.0 },
    fogColor: { type: "c", value: this.scene.fog.color },
    fogNear : { type: "f", value: 1000.0 },
    fogFar  : { type: "f", value: 2000.0 },
//            fogDensity:{type: "f", value: 500.0 },
  };
  this.cloudMaterial = new THREE.ShaderMaterial({uniforms: this.cloudUniforms,
      vertexShader: document.getElementById('plasma_vertex').textContent,
      fragmentShader: document.getElementById("plasma").textContent,
      side: THREE.BackSide,
      fog: true
  });

  var geo = new THREE.PlaneGeometry(1600,1600);
  this.cloudPlane = new THREE.Mesh(geo, this.cloudMaterial);
  this.cloudPlane.rotation.x = -Math.PI/2;
  this.cloudPlane.position.y = 200;
  this.scene.add(this.cloudPlane);
}

Forward.prototype.createPreScene = function(){
  //Sisään feidaus
  this.preScene = new THREE.Scene();
  this.preCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.preCamera.position.z = 1;
  this.preScene.add(this.preCamera);
}

Forward.prototype.createPostScene = function(){
  //Silmien räpyttely
  this.postScene = new THREE.Scene();
  this.postCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.postCamera.position.z = 1;
  this.postScene.add(this.postCamera);
  
  this.uniformsBlink =  {
    phase : {type : "f", value: 2.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
    texture : {type : "t", value: this.rtt}
  };

  this.blinkMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsBlink,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'blink').textContent
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.blinkMaterial);
  this.postScene.add(this.plane);
}
