
//nimiavaruus
TDEMO = {
  audioStatus : false,
  inited : false,
  user : false
};

//aloitetaan demo, kun kaikki alustustoimenpiteet
//on varmasti suoritettu
var allLoaded = function(){
  if(TDEMO.audioStatus && TDEMO.inited && TDEMO.user){
    TDEMO.mainloop();
  }
};

var audioReady = function(){
  TDEMO.audioStatus = true;
  TDEMO.audio = document.getElementById("audio");
  allLoaded();
};

var start = function(){

  var demoEl = document.getElementById("demo");
  
  if(demoEl.requestFullscreen){
    demoEl.requestFullscreen();
  }
  else if(demoEl.mozRequestFullScreen){
    demoEl.mozRequestFullScreen();
  }
  else if (demoEl.webkitRequestFullscreen){
    demoEl.webkitRequestFullscreen();
  }else{
    console.log("fail");
  }

  document.getElementById("start").style.display = "none";
  document.getElementById("demo").style.display = "block";
  
  //Vhn timeouttia thn, ett kyttj ehtii painaa
  //allow -nappia fullscreen modeen siirryttess ennen demon alkua.
  setTimeout(function(){
    console.log("Let's start!");
    TDEMO.user = true;
    allLoaded();
  }, 5000);
}

//alustusfunktio, joka luo juttuja nimiavaruuteen.
var init = function(){  

  TDEMO.width = screen.width;
  TDEMO.height = screen.height;
  
  //alustetaan renderer
  TDEMO.renderer = new THREE.WebGLRenderer();
  TDEMO.renderer.setSize(TDEMO.width, TDEMO.height);
  TDEMO.renderer.setClearColor(0x302B54);
  
  TDEMO.renderer.domElement.style.width = TDEMO.width;
  TDEMO.renderer.domElement.style.height = TDEMO.height;
  document.getElementById("demo").appendChild(TDEMO.renderer.domElement);
  
  TDEMO.rtt = new THREE.WebGLRenderTarget(1024, 1024);
  
  //ajastus ja parttien vaihto
  TDEMO.currentPart = 0;
  TDEMO.nextPart = 1;
  
  TDEMO.timeElapsed = 0;
  
  //beats per minute
  TDEMO.bpm = 90;
  //bars per minute
  TDEMO.barspm = 90/3;
  
  //seconds per beat (beattien vlinen aika sekunteina)
  //n. 0,6667s
  TDEMO.spb = (1/(TDEMO.bpm/60));
  
  //seconds per bar (tahtien vlinen aika sekunteina)
  // 2
  TDEMO.spbar = (1/(TDEMO.barspm/60));
  
  //kuinka kauan musiikki kest sekunteissa
  TDEMO.music_duration = 180;
  
  //Thn luodaan partit
  TDEMO.parts = [
 
    //part duration, start time, end time in seconds!
    new Ambience(5*TDEMO.spbar, 0, 5*TDEMO.spbar),//10, 0, 10
    new Forward(28*TDEMO.spbar, 5*TDEMO.spbar, 33*TDEMO.spbar),
    new Balls(15*TDEMO.spbar, 33*TDEMO.spbar, 48*TDEMO.spbar),
    new Newpart(27*TDEMO.spbar, 48*TDEMO.spbar, 75*TDEMO.spbar),
    new Tunnel(13*TDEMO.spbar, 75*TDEMO.spbar, 88*TDEMO.spbar),
   ];
  
  //taulukko tekstityksist
  //kesto on merkitty vain niille teksteille, jotka eivt vaihdu suoraa seuraavaan.
  TDEMO.subtitles = [
    {id : "mista", start:12, end: false },

    {id : "tytot1", start:16, end: false },
    {id : "tytot2", start:18, end: false },
    {id : "tytot3", start:22, end: 25 },
    
    {id : "sade1", start:26, end: false },
    {id : "sade2", start:31, end: 35 },
    
    {id : "pojat1", start:42, end: false },
    {id : "pojat2", start:45, end: false },
    {id : "pojat3", start:49, end: 53 },
    
    {id : "aurinko1", start:54, end: false },
    {id : "aurinko2", start:59, end: 63 },
    
    {id : "minut1", start:102, end: false },
    {id : "minut2", start:105, end: false },
    {id : "minut3", start:107, end: false },
    {id : "minut4", start:109, end: false },
    {id : "minut5", start:112, end: 116 },
    
    {id : "ketaan1", start:150, end: false },
    {id : "ketaan2", start:153, end: false },
    {id : "ketaan3", start:157, end: 160 }
  ];
  
  TDEMO.nextSub = 0;
  TDEMO.currentSub = 0;
  TDEMO.subsStarted = false;
  
  //alustetaan partit
  for(var i = 0; i < TDEMO.parts.length; ++i){
    //tss kutsutaan partin alustusfunktiota, joka
    //luo partin scenen
    TDEMO.parts[i].initScene();
  }
  
  TDEMO.started = false;
  
  TDEMO.mainloop = function(){

    if(!TDEMO.started){
      TDEMO.started = true;
      TDEMO.audio.play();
    }
    
    TDEMO.timeElapsed = TDEMO.audio.currentTime;
    
    //tekstitys
    if(TDEMO.nextSub < TDEMO.subtitles.length && TDEMO.timeElapsed >= TDEMO.subtitles[TDEMO.nextSub].start){
      if(TDEMO.subsStarted){
        document.getElementById(TDEMO.subtitles[TDEMO.currentSub].id).style.display = "none";
      }
      else{
        TDEMO.subsStarted = true;
      }
      document.getElementById(TDEMO.subtitles[TDEMO.nextSub].id).style.display = "inline";
      TDEMO.currentSub = TDEMO.nextSub;
      ++TDEMO.nextSub;
    }
    
    if(TDEMO.subtitles[TDEMO.currentSub].end && TDEMO.timeElapsed >= TDEMO.subtitles[TDEMO.currentSub].end){
      document.getElementById(TDEMO.subtitles[TDEMO.currentSub].id).style.display = "none";
    }
    
    //partin vaihto
    if(TDEMO.timeElapsed >= TDEMO.parts[TDEMO.currentPart].endTime && TDEMO.nextPart < TDEMO.parts.length){
      
      TDEMO.parts[TDEMO.currentPart].finish(TDEMO.timeElapsed, TDEMO.rtt);
      TDEMO.parts[TDEMO.nextPart].prepare(TDEMO.timeElapsed, TDEMO.rtt);
      
      TDEMO.currentPart = TDEMO.nextPart;
      ++TDEMO.nextPart;
      
    }
    else if(TDEMO.timeElapsed >= TDEMO.parts[TDEMO.currentPart].endTime && TDEMO.nextPart >= TDEMO.parts.length){
      //Kun ei ole en partteja jljell, nytetn creditsit ja lopetetaan animointi ja renderinti
      //cancelAnimationFrame(TDEMO.mainloop);
      //document.getElementById("demo").style.display = "none";
      document.getElementById("credits").style.display = "block";
      //en ei ole mitn renderitv tai animoitavaa, joten palataan funktiosta tss kohtaa
      return;
    }
    
    //Renderinti tapahtuu kun partti vaihdetaan ja kun ei olla lopussa.
    //Eli kun vain ensimminen if toteutuu tai kun sek if ett else if ovat molemmat eptosia.
    TDEMO.parts[TDEMO.currentPart].animate(TDEMO.timeElapsed);
    TDEMO.parts[TDEMO.currentPart].render(TDEMO.timeElapsed);
    requestAnimationFrame(TDEMO.mainloop);
  }
  
  //alustus on tehty, kutsutaan tarkastusfunktiota
  TDEMO.inited = true;
  allLoaded();
}
