﻿// Tunnel-scene


var Tunnel = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Tunnel.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Tunnel.prototype.initScene = function(){
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  
  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 400;
  this.scene.add(this.camera);
  
  var ambient = new THREE.AmbientLight(0xFAF0F6);
  this.scene.add(ambient);
  
  this.lights = new THREE.Object3D();
  this.createLights(5);
  this.scene.add(this.lights);
  
  THREE.ImageUtils.crossOrigin = true;
  this.tunnelTexture = THREE.ImageUtils.loadTexture("bin/sateenkaari_pieni.png");
  this.tunnelTexture.wrapS = THREE.RepeatWrapping;
  this.tunnelTexture.wrapT = THREE.RepeatWrapping;
  this.tunnelTexture.repeat.set(1,8);

  var cylinder = new THREE.CylinderGeometry(4, 8, 1000, 128, 128, true);
  var material = new THREE.MeshPhongMaterial({
    ambient : 0xC0D9D9,
    emissive : 0xC1CDCD,
    specular : 0x668B8B,
    shininess: 80,
    map : this.tunnelTexture,
    side: THREE.BackSide
  });
  this.mesh = new THREE.Mesh(cylinder, material);
  this.mesh.rotation.x = Math.PI/2;
  this.scene.add(this.mesh);
  
  
  var skyMaterial = new THREE.MeshPhongMaterial({
    color : 0x838B8B,
    ambient : 0xC0D9D9,
    emissive : 0xC1CDCD,
    specular : 0x668B8B
  });
  var sky = new THREE.Mesh(new THREE.PlaneGeometry(1600, 1600), skyMaterial);
  sky.position.z = -800;
  this.scene.add(sky);
  
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  
  this.rtt = new THREE.WebGLRenderTarget(1024, 1024);
  this.preScene = new THREE.Scene();
  this.preCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.preCamera.position.z = 1;
  this.preScene.add(this.preCamera);
  
  this.fadeIn = {t : this.startTime+1, done : false};
  this.swipeSpeed = 0.01;
  
  this.rv = (Math.PI*4) / this.duration;
  this.ov = -6/this.duration;
}

//rendering function
Tunnel.prototype.render = function(elapsedTime){
  if(!this.fadeIn.done){
    TDEMO.parts[TDEMO.currentPart-1].finish(elapsedTime, this.rtt2);
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.preScene, this.preCamera);
  }
  else{
    TDEMO.renderer.render(this.scene, this.camera);
  }
}

Tunnel.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
  
  this.rtt2 = rtt;
  this.uniformsSwipe =  {
    angle : {type : "f", value: -2.0},
    scene1 : {type : "t", value: this.rtt2},
    scene2 : {type : "t", value: this.rtt},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
  };

  this.swipeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsSwipe,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'swipe').textContent,
  });
  
  this.prePlane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.swipeMaterial);
  this.preScene.add(this.prePlane);
}

Tunnel.prototype.animate = function(elapsedTime){
  
  //sisäänfeidaus
  if(!this.fadeIn.done && elapsedTime >= this.fadeIn.t){
    
    this.uniformsSwipe.angle.value += this.swipeSpeed;
    
    TDEMO.parts[TDEMO.currentPart-1].animate(elapsedTime);
    
    if(this.uniformsSwipe.angle.value >= 0.5){
      console.log("fade in done");
      this.fadeIn.done = true;
    }
  }
  
  this.tunnelTexture.offset.y = this.ov*(elapsedTime - this.startTime);
  this.tunnelTexture.offset.y %= 1;
  this.tunnelTexture.needsUpdate = true;
  
  this.lights.rotation.z = this.rv*(elapsedTime - this.startTime);
}

Tunnel.prototype.createLights = function(lights_amount){
  
  var r = 40;
  var delta = 2*Math.PI/lights_amount;
  var alpha = 0;
  
  for(var i = 0; i < lights_amount; ++i){
    
    var light = new THREE.PointLight(0xCDC9C9);
    
    light.position.z = 300;
    light.position.y = Math.sin(alpha)*r;
    light.position.x = Math.cos(alpha)*r;
    
    var light2 = new THREE.PointLight(0xEEDC82);
    light2.position.z = -250;
    light2.position.y = Math.sin(alpha)*r;
    light2.position.x = Math.cos(alpha)*r;
    
    this.lights.add(light);
    this.lights.add(light2);
    
    alpha += delta;
  }
}
