#version 330 core

// Interpolated values from the vertex shaders
in vec2 UV;
uniform sampler2D inputtex;
uniform float bwmix;
uniform float iGlobalTime;

// output
layout(location = 0) out vec4 color;


vec3 mod289(vec3 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec2 mod289(vec2 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec3 permute(vec3 x) {
  return mod289(((x*34.0)+1.0)*x);
}

float snoise(vec2 v)
  {
  const vec4 C = vec4(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0
  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);
  vec2 i1;
  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;
  i = mod289(i);
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 )) + i.x + vec3(0.0, i1.x, 1.0 ));
  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;
  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );
  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 tonemap(vec4 iColor) {
	return vec4(iColor.rgb, dot(iColor.rgb, vec3(0.299, 0.587, 0.114)));
}

vec4 blackwhitetransform(vec4 iColor, float mixf) {
	return (1.0 - mixf) * iColor + mixf * vec4(vec3(dot(iColor.rgb, vec3(0.299, 0.587, 0.114))), iColor.a);
}

void main(){
	if( UV.y < 0.1222 || UV.y > 0.8777 ) {
		color = vec4(vec3(0.0), 1.0);
	} else {
		vec4 eColor = texture(inputtex, UV);
		
		eColor.x = smoothstep(0.1,  0.9 , eColor.x);
		eColor.y = smoothstep(0.05, 1.05, eColor.y);
		eColor.z = smoothstep(0.0,  1.1, eColor.z);
		
		eColor += vec4(0.022*vec3(rand(UV * vec2(iGlobalTime) )), 1.0 );
		eColor += vec4( 0.04*vec3(snoise(UV*333.3 + vec2(iGlobalTime*1000.0) )), 1.0 );

		color = blackwhitetransform(tonemap(eColor), bwmix);
	}

	//color = texture(inputtex, UV);
}
