#version 120

varying vec2 UV;

uniform sampler2D fp_texture;
uniform float time;
const vec2 iResolution = vec2(1024.0, 768.0);


vec2 transform(vec2 coord) {
    return 2.0 * (coord - 0.5);
}

vec2 invtransform(vec2 coord) {
    return (0.5 + 0.5 * coord);
}

vec4 radial(vec2 coord) {
#define NSCALES 512
    vec2 transformed = transform(coord);
    vec4 outp = vec4(0.0);
    float suma = float(0.0);
    for ( int i = 0; i < NSCALES; i++ ) {
        float weight = NSCALES - pow(i, 0.24);
        vec4 tempcol = texture2D(fp_texture, invtransform(i * transformed / NSCALES));
        outp += weight*tempcol;
        suma += weight;
    }
    return outp / suma;
}

void main(){
    vec4 rcolor = texture2D( fp_texture, UV ) + radial(UV);
    gl_FragColor = vec4(min(vec3(1.0), rcolor.rgb), 1.0);
}