#version 330 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexnormal;

// Output data ; will be interpolated for each fragment.
out vec2 UV;
out vec3 normal;
out vec4 pos;

// Values that stay constant for the whole mesh.
uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;

void main(){
	// Output position of the vertex, in clip space : MVP * position
	pos = MVP * vec4(vertexPos,1.0);
	gl_Position = pos;
	
	// UV of the vertex. No special space for this one.
	UV = vertexUV;

	// Vertex normal shiat.
	vec4 temp = transpose(inverse(V * M)) * vec4(normalize(vertexnormal), 0.0);
	normal = normalize(temp.xyz);
}

